<?xml version="1.0" encoding="UTF-8"?>
<!-- stylesheet converting xmi to gxl-->

<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:UML="http://www.omg.org/uml/1.3"
                xmlns:xlink="http://www.w3.org/1999/xlink">
                
                
	<xsl:output method="xml" 
	            omit-xml-declaration="no"
	            standalone="no"
			    indent="yes"
			    doctype-system="http://www.upb.de/cs/fujaba/DTDs/gxl.dtd"/>
			
	<xsl:variable name="VISIBILITY_PRIVATE"  >0</xsl:variable>
	<xsl:variable name="VISIBILITY_PUBLIC"   >1</xsl:variable>
	<xsl:variable name="VISIBILITY_PROTECTED">2</xsl:variable>
	<xsl:variable name="VISIBILITY_PACKAGE"  >3</xsl:variable>
	<xsl:variable name="VISIBILITY_USERDEF"  >4</xsl:variable>

	<xsl:variable name="ROLE_AGGREGATION">1</xsl:variable>
	<xsl:variable name="ROLE_COMPOSITION">2</xsl:variable>

	<xsl:variable name="TYPELIST">typelist</xsl:variable>
	<xsl:variable name="PROJECT">umlproject</xsl:variable>
	
	

	<xsl:key name="class" match="UML:Class" use="@name"/>
	<xsl:key name="datatype.id" match="UML:DataType" use="@xmi.id"/>


	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="XMI">
		<xsl:element name="gxl">
			<xsl:element name="graph">
				<xsl:attribute name="id">
				     <xsl:value-of select="XMI.header/XMI.documentation/XMI.exporter/text()"/>
				</xsl:attribute>
			
				<xsl:apply-templates select="XMI.content"/>	
			
				<!-- no uml:file -->

				<!-- umlproject MUST be last -->
				<xsl:element name="node">
					<xsl:attribute name="id">
						<xsl:value-of select="$PROJECT"/>
					</xsl:attribute>
					<xsl:element name="type">
						<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLProject</xsl:attribute>
						<xsl:attribute name="xlink:type">simple</xsl:attribute>
					</xsl:element>
					
					<!--weg lassen ??-->	
					<xsl:element name="attr">
						<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLProject::rootDir</xsl:attribute>
				        <string>c:\temp\NewFujabaApp</string>
			        </xsl:element>
					<xsl:element name="attr">
						<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLProject::name</xsl:attribute>
				        <string>imported</string>
			       	</xsl:element>
				</xsl:element>
			   
			</xsl:element>	
		</xsl:element>	
	</xsl:template>
	
	
	
	<xsl:template match="XMI.content">
		<!-- diagram first-->
		<xsl:apply-templates select="UML:Diagram"/>
	     	<xsl:apply-templates select="UML:Model"/>
		<xsl:apply-templates select="UML:TaggedValue"/>
	</xsl:template>
	

	<xsl:template match="UML:Model">
		<!-- generate typelist-->
		<!-- edges generated at classes and datatypes-->		
		<xsl:element name="node">
			<xsl:attribute name="id">
				<xsl:value-of select="$TYPELIST"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLTypeList</xsl:attribute>
				<xsl:attribute name="xlink:type">simple</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates/>
	</xsl:template>


	<xsl:template match="UML:Namespace.ownedElement">
		<xsl:apply-templates/>
	</xsl:template>


	<!-- subpackages ? -->
	<xsl:template match="UML:Package">
		<xsl:element name="node">
			<xsl:attribute name="id">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLPackage</xsl:attribute>
				<xsl:attribute name="xlink:type">simple</xsl:attribute>
			</xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLPackage::name</xsl:attribute>
                <string><xsl:value-of select="@name"/></string>
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="UML:DataType">
		<!-- only java datatype, no classes -->
		<xsl:if test="count(key('class',@name))=0">
			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLBaseTypes</xsl:attribute>
					<xsl:attribute name="xlink:type">simple</xsl:attribute>
				</xsl:element>
				<xsl:element name="attr">
					<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLBaseTypes::name</xsl:attribute>
					<xsl:element name="string">
						<xsl:choose>
							<xsl:when test="contains(@name,'java.lang.')">
								<xsl:value-of select="substring-after(@name,'java.lang.')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@name"/>
							</xsl:otherwise>
						</xsl:choose>	
		            </xsl:element>
	    	    </xsl:element>
			</xsl:element>
		
			<!-- typelist edges -->
			<xsl:element name="edge">           
				<xsl:attribute name="from">
					<xsl:value-of select="$TYPELIST"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLTypeList::types</xsl:attribute>
				</xsl:element>
				<xsl:element name="attr">
					<xsl:attribute name="name">key</xsl:attribute>
					<xsl:element name="string">
						<xsl:choose>
							<xsl:when test="contains(@name,'java.lang.')">
								<xsl:value-of select="substring-after(@name,'java.lang.')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@name"/>
							</xsl:otherwise>
						</xsl:choose>	
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>


	<xsl:template match="UML:Association">
		<xsl:variable name="assocNamespace">
			<xsl:value-of select="@xmi.id"/>
		</xsl:variable>
	
		<xsl:element name="node">
			<xsl:attribute name="id">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLAssoc</xsl:attribute>
				<xsl:attribute name="xlink:type">simple</xsl:attribute>
			</xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLAssoc::name</xsl:attribute>
				<xsl:element name="string">
		        	<xsl:value-of select="@name"/>
            	</xsl:element>
			</xsl:element>
		</xsl:element>			
			
		<xsl:for-each select="UML:Association.connection/UML:AssociationEnd">
			<xsl:variable name="class">
				<xsl:value-of select="UML:AssociationEnd.type/Foundation.Core.Classifier/@xmi.idref"/>
			</xsl:variable>
			<!-- edges to roles-->
			<xsl:element name="edge">
				<xsl:attribute name="from">
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:text>role.</xsl:text>
					<xsl:value-of select="$class"/>
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:if test="position()=1">
							<xsl:text>de.uni_paderborn.fujaba.uml.UMLAssoc::leftRole</xsl:text>
						</xsl:if>
						<xsl:if test="position()=2">
							<xsl:text>de.uni_paderborn.fujaba.uml.UMLAssoc::rightRole</xsl:text>
						</xsl:if>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			
			<!-- uml:role -->
			
			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:text>role.</xsl:text>
					<xsl:value-of select="$class"/>
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLRole</xsl:attribute>
					<xsl:attribute name="xlink:type">simple</xsl:attribute>
				</xsl:element>
				<xsl:element name="attr">
					<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLRole::name</xsl:attribute>
					<xsl:element name="string">
	    		    	<xsl:value-of select="@name"/>
           			</xsl:element>
				</xsl:element>
				
				<xsl:element name="attr">
					<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLRole::adornment</xsl:attribute>
					<xsl:element name="string">
						<xsl:choose>
							<xsl:when test="@aggregation='aggregate'">
								<xsl:value-of select="$ROLE_AGGREGATION"/>
							</xsl:when>
							<xsl:when test="@aggregation='composite'">
								<xsl:value-of select="$ROLE_COMPOSITION"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>0</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
           			</xsl:element>
				</xsl:element>
				<xsl:element name="attr">
					<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLRole::umlVisibility</xsl:attribute>
					<xsl:element name="string">
				        <xsl:choose>
				        	<xsl:when test="@visibility='private'">
				        		<xsl:value-of select="$VISIBILITY_PRIVATE"/>
		    		    	</xsl:when>
							<xsl:when test="@visibility='public'">
			        			<xsl:value-of select="$VISIBILITY_PUBLIC"/>
							</xsl:when>
							<xsl:when test="@visibility='protected'">
				        		<xsl:value-of select="$VISIBILITY_PROTECTED"/>
							</xsl:when>
							<xsl:when test="@visibility='package'">
			    	    		<xsl:value-of select="$VISIBILITY_PACKAGE"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$VISIBILITY_USERDEF"/>
							</xsl:otherwise>
		    	    	</xsl:choose>
           			</xsl:element>
				</xsl:element>
			</xsl:element>
			
			<!-- edge class -> role -->
			<xsl:element name="edge">
				<xsl:attribute name="from">
					<xsl:value-of select="$class"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:text>role.</xsl:text>
					<xsl:value-of select="$class"/>
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLClass::roles</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			
			<!-- edge role -> card -->
			<xsl:element name="edge">
				<xsl:attribute name="from">
					<xsl:text>role.</xsl:text>
					<xsl:value-of select="$class"/>
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:text>card.role.</xsl:text>
					<xsl:value-of select="$class"/>
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLRole::card</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			
			
			<!-- edge role -> attr -->
			
			
			<!-- card -->
			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:text>card.role.</xsl:text>
					<xsl:value-of select="$class"/>
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:element name="type">									     
					<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLCardinality</xsl:attribute>
					<xsl:attribute name="xlink:type">simple</xsl:attribute>
				</xsl:element>
				<xsl:element name="attr">								   
					<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLCardinality::cardString</xsl:attribute>
					<xsl:element name="string">
						<xsl:if test="UML:AssociationEnd.multiplicity/UML:Multiplicity/UML:Multiplicity.range/UML:MultiplicityRange">
							<xsl:value-of select="UML:AssociationEnd.multiplicity/UML:Multiplicity/UML:Multiplicity.range/UML:MultiplicityRange/@lower"/>
							<xsl:text>..</xsl:text>
	    	        		<xsl:value-of select="UML:AssociationEnd.multiplicity/UML:Multiplicity/UML:Multiplicity.range/UML:MultiplicityRange/@upper"/>
	        			</xsl:if>    		
	            	</xsl:element>
				</xsl:element>
			</xsl:element>
		
		
			<!--unwichtig-->
			<!-- edge card -> role -->
			<xsl:element name="edge">
				<xsl:attribute name="from">
					<xsl:text>card.role.</xsl:text>
					<xsl:value-of select="$class"/>
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:text>role.</xsl:text>
					<xsl:value-of select="$class"/>
					<xsl:text>.</xsl:text>
					<xsl:value-of select="$assocNamespace"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLCardinality::revCard</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			
		
		</xsl:for-each>
	</xsl:template>


	<xsl:template match="UML:Class">
		<xsl:variable name="classNamespace">
			<xsl:value-of select="@xmi.id"/>
		</xsl:variable>
		
		<xsl:element name="node">
			<xsl:attribute name="id">
				<xsl:value-of select="$classNamespace"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLClass</xsl:attribute>
				<xsl:attribute name="xlink:type">simple</xsl:attribute>
			</xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLClass::name</xsl:attribute>
		                <string><xsl:value-of select="@name"/></string>
	                </xsl:element>

			<!-- fix me -->         
			<xsl:element name="attr">
				<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLDeclaration::visibility</xsl:attribute>
				<xsl:element name="string">
			        <xsl:choose>
			        	<xsl:when test="@visibility='private'">
			        		<xsl:value-of select="$VISIBILITY_PRIVATE"/>
	    		    	</xsl:when>
						<xsl:when test="@visibility='public'">
		        			<xsl:value-of select="$VISIBILITY_PUBLIC"/>
						</xsl:when>
						<xsl:when test="@visibility='protected'">
			        		<xsl:value-of select="$VISIBILITY_PROTECTED"/>
						</xsl:when>
						<xsl:when test="@visibility='package'">
		    	    		<xsl:value-of select="$VISIBILITY_PACKAGE"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$VISIBILITY_USERDEF"/>
						</xsl:otherwise>
	    	    	</xsl:choose>
     			</xsl:element>
			</xsl:element>
		
		</xsl:element>
		
		<!-- reference of UMLProject -->
		<xsl:element name="edge">           
			<xsl:attribute name="from">
				<xsl:value-of select="$PROJECT"/>
			</xsl:attribute>
			<xsl:attribute name="to"> 
				<xsl:value-of select="$classNamespace"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLProject::references</xsl:attribute>
			</xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">key</xsl:attribute>
				<xsl:element name="string">
					<xsl:value-of select="@name"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>

		<!-- edge to $PROJECT -->
		
		<xsl:element name="edge">           
			<xsl:attribute name="from">
				<xsl:value-of select="$classNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="to">
				<xsl:value-of select="$PROJECT"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLClass::declaredInReferences</xsl:attribute>
			</xsl:element>
		</xsl:element>

		
		<!-- package-->
		
		<xsl:element name="edge">           
			<xsl:attribute name="from">
				<xsl:value-of select="$classNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="to">
				<xsl:value-of select="../../@xmi.id"/> <!--package id-->
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLClass::declaredInPackage</xsl:attribute>
			</xsl:element>
		</xsl:element>
		
				 
		<xsl:for-each select="UML:Classifier.feature">	 		<!-- attr & methods-->
			<xsl:for-each select="UML:Operation">	 
				<xsl:call-template name="UML:Operation">
					<xsl:with-param name="classNamespace">
						<xsl:value-of select="$classNamespace"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
			<xsl:for-each select="UML:Attribute">	 
				<xsl:call-template name="UML:Attribute">
					<xsl:with-param name="classNamespace">
						<xsl:value-of select="$classNamespace"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
			
		</xsl:for-each> 
		
		<xsl:apply-templates select="UML:Namespace.ownedElement"/> 	<!--gen-->
		
		<!-- typelist edge -->
		<xsl:element name="edge">           
			<xsl:attribute name="from">
				<xsl:value-of select="$TYPELIST"/>
			</xsl:attribute>
			<xsl:attribute name="to">
				<xsl:value-of select="$classNamespace"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLTypeList::types</xsl:attribute>
			</xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">key</xsl:attribute>
				<xsl:element name="string">
					<xsl:value-of select="@name"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
		
	</xsl:template> <!--UML:Class-->


	<xsl:template match="UML:Generalization">
		<xsl:element name="node">
			<xsl:attribute name="id">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLGeneralization</xsl:attribute>
				<xsl:attribute name="xlink:type">simple</xsl:attribute>
			</xsl:element>
                </xsl:element>
<!--superclass--><xsl:element name="edge">           
			<xsl:attribute name="from">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:attribute name="to">
				<xsl:value-of select="UML:Generalization.parent/Foundation.Core.GeneralizableElement/@xmi.idref"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLGeneralization::superclass</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:element name="edge">           
			<xsl:attribute name="from">
				<xsl:value-of select="UML:Generalization.parent/Foundation.Core.GeneralizableElement/@xmi.idref"/>
			</xsl:attribute>
			<xsl:attribute name="to">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLClass:revSuperclass</xsl:attribute>
			</xsl:element>
		</xsl:element>
<!--subclass-->	<xsl:element name="edge">           
			<xsl:attribute name="from">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:attribute name="to">
				<xsl:value-of select="UML:Generalization.child/Foundation.Core.GeneralizableElement/@xmi.idref"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLGeneralization::subclass</xsl:attribute>
			</xsl:element>
		</xsl:element>
		<xsl:element name="edge">           
			<xsl:attribute name="from">
				<xsl:value-of select="UML:Generalization.child/Foundation.Core.GeneralizableElement/@xmi.idref"/>
			</xsl:attribute>
			<xsl:attribute name="to">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLClass:revSubclass</xsl:attribute>
			</xsl:element>
		</xsl:element>

	</xsl:template>



	<xsl:template name="UML:Attribute">
		<xsl:param name="classNamespace"/>
		<xsl:element name="node">
			<xsl:attribute name="id">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLAttr</xsl:attribute>
				<xsl:attribute name="xlink:type">simple</xsl:attribute>
			</xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLAttr::name</xsl:attribute>
					<xsl:element name="string">
		                <xsl:value-of select="@name"/>
		            </xsl:element>
	        </xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLAttr::umlVisibility</xsl:attribute>
		        <xsl:element name="string">
			        <xsl:choose>
			        	<xsl:when test="@visibility='private'">
			        		<xsl:value-of select="$VISIBILITY_PRIVATE"/>
		    	    	</xsl:when>
						<xsl:when test="@visibility='public'">
			        		<xsl:value-of select="$VISIBILITY_PUBLIC"/>
						</xsl:when>
						<xsl:when test="@visibility='protected'">
			        		<xsl:value-of select="$VISIBILITY_PROTECTED"/>
						</xsl:when>
						<xsl:when test="@visibility='package'">
			        		<xsl:value-of select="$VISIBILITY_PACKAGE"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$VISIBILITY_USERDEF"/>
						</xsl:otherwise>
		        	</xsl:choose>
		        </xsl:element>        
	        </xsl:element>

			<!-- initial value -->
			<xsl:if test="UML:Attribute.initialValue">
				<xsl:element name="attr">
					<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLAttr::initialValue</xsl:attribute>
						<xsl:element name="string">
		    	            <xsl:value-of select="UML:Attribute.initialValue/UML:Expression/@body"/>
		        	    </xsl:element>
	        	</xsl:element>
	        </xsl:if>
		</xsl:element>

		<xsl:variable name="t_from">
			<xsl:value-of select="@xmi.id"/>
		</xsl:variable>
		
		<!-- edge to type -->
		<xsl:variable name="t_type">
			<xsl:value-of select="UML:StructuralFeature.type/Foundation.Core.Classifier/@xmi.idref"/>
		</xsl:variable>
		
		<xsl:for-each select="key('datatype.id',$t_type)">
			<xsl:choose>
				<xsl:when test="count(key('class',@name))>0"> 	<!-- type is a class -->
					<xsl:for-each select="key('class',@name)">
						<xsl:element name="edge">           
							<xsl:attribute name="from">
								<xsl:value-of select="$t_from"/>
							</xsl:attribute>
							<xsl:attribute name="to">
								<xsl:value-of select="@xmi.id"/>
							</xsl:attribute>
							<xsl:element name="type">
								<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLAttr::attrType</xsl:attribute>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
				</xsl:when>		
				<xsl:otherwise>	
					<!-- type is NOT a class -->
					<xsl:element name="edge">           
						<xsl:attribute name="from">
							<xsl:value-of select="$t_from"/>
						</xsl:attribute>
						<xsl:attribute name="to">
							<xsl:value-of select="$t_type"/>				
						</xsl:attribute>
						<xsl:element name="type">
							<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLAttr::attrType</xsl:attribute>
						</xsl:element>
					</xsl:element>			
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>

		<!-- edge class attr -->
			<xsl:element name="edge">     
				<xsl:attribute name="from">
					<xsl:value-of select="$classNamespace"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLClass::attrs</xsl:attribute>
				</xsl:element>
				<xsl:element name="attr">
					<xsl:attribute name="name">key</xsl:attribute>
					<xsl:element name="string">
						<xsl:value-of select="@name"/>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		
		<!-- access methods -->
	</xsl:template>


	<xsl:template name="UML:Operation">  <!-- methods -->
		<xsl:param name="classNamespace"/>
		<xsl:variable name="operationNamespace">
			<xsl:value-of select="@xmi.id"/>
		</xsl:variable>

		<xsl:element name="node">
			<xsl:attribute name="id">
				<xsl:value-of select="@xmi.id"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLMethod</xsl:attribute>
				<xsl:attribute name="xlink:type">simple</xsl:attribute>
			</xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLMethod::name</xsl:attribute>
		                <string><xsl:value-of select="@name"/></string>
	                </xsl:element>

			
			<xsl:element name="attr">
				<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLDeclaration::visibility</xsl:attribute>
		    	<xsl:element name="string">    	
			        <xsl:choose>
			        	<xsl:when test="@visibility='private'">
			        		<xsl:value-of select="$VISIBILITY_PRIVATE"/>
		    	    	</xsl:when>
						<xsl:when test="@visibility='public'">
			        		<xsl:value-of select="$VISIBILITY_PUBLIC"/>
						</xsl:when>
						<xsl:when test="@visibility='protected'">
			        		<xsl:value-of select="$VISIBILITY_PROTECTED"/>
						</xsl:when>
						<xsl:when test="@visibility='package'">
			        		<xsl:value-of select="$VISIBILITY_PACKAGE"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$VISIBILITY_USERDEF"/>
						</xsl:otherwise>
		        	</xsl:choose>
		 	    </xsl:element>    	
			</xsl:element>

		</xsl:element>


		<xsl:for-each select="UML:BehavioralFeature.parameter">
			<xsl:if test="count(UML:Parameter[@kind='return'])>0">  <!-- result -->
				<xsl:variable name="id">
					<xsl:value-of select="UML:Parameter/UML:Parameter.type/Foundation.Core.Classifier/@xmi.idref"/>
				</xsl:variable>
				
				<!-- direct to class -->
				<xsl:for-each select="key('datatype.id',$id)">
					<xsl:choose>
						<xsl:when test="count(key('class',@name))>0"> 	<!-- type is a class -->
							<xsl:for-each select="key('class',@name)">
								<xsl:element name="edge">           
									<xsl:attribute name="from">
										<xsl:value-of select="$operationNamespace"/>
									</xsl:attribute>
									<xsl:attribute name="to">				
										<xsl:value-of select="@xmi.id"/>
									</xsl:attribute>	
									<xsl:element name="type">
										<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLMethod::resultType</xsl:attribute>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<!-- type is NOT a class -->
							<xsl:element name="edge">           
								<xsl:attribute name="from">
									<xsl:value-of select="$operationNamespace"/>
								</xsl:attribute>
								<xsl:attribute name="to">
									<xsl:value-of select="$id"/>
								</xsl:attribute>				
								<xsl:element name="type">
									<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLMethod::resultType</xsl:attribute>
								</xsl:element>
							</xsl:element>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:if>
			
		
			<xsl:if test="count(UML:Parameter[@kind='inout'])>0">  <!-- parameter -->
				<xsl:element name="edge">           
					<xsl:attribute name="from">
						<xsl:value-of select="$operationNamespace"/>
					</xsl:attribute>
					<xsl:attribute name="to">
						<xsl:value-of select="UML:Parameter/@xmi.id"/>
					</xsl:attribute>
					<xsl:element name="type">
						<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLMethod::param</xsl:attribute>
					</xsl:element>
				</xsl:element>
				<xsl:element name="node">
					<xsl:attribute name="id">
						<xsl:value-of select="UML:Parameter/@xmi.id"/>
					</xsl:attribute>
					<xsl:element name="type">
						<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLParam</xsl:attribute>
						<xsl:attribute name="xlink:type">simple</xsl:attribute>
					</xsl:element>
					<xsl:element name="attr">
						<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLParam::name</xsl:attribute>
						<xsl:element name="string">
				        	<xsl:value-of select="UML:Parameter/@name"/>
				        </xsl:element>    
			        </xsl:element>
				</xsl:element>

				<xsl:variable name="id">
					<xsl:value-of select="UML:Parameter/UML:Parameter.type/Foundation.Core.Classifier/@xmi.idref"/>
				</xsl:variable>
				<xsl:variable name="from">
					<xsl:value-of select="UML:Parameter/@xmi.id"/>
				</xsl:variable>
				<!-- direct to class -->

				<xsl:for-each select="key('datatype.id',$id)">
					<xsl:choose>
						<xsl:when test="count(key('class',@name))>0"> 	<!-- type is a class -->
							<xsl:for-each select="key('class',@name)">
								<xsl:element name="edge">           
									<xsl:attribute name="from">
										<xsl:value-of select="$from"/>
									</xsl:attribute>
									<xsl:attribute name="to">				
										<xsl:value-of select="@xmi.id"/>
									</xsl:attribute>	
									<xsl:element name="type">
										<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLParam::paramType</xsl:attribute>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>	
						<!-- type is NOT a class -->
							<xsl:element name="edge">           
								<xsl:attribute name="from">
									<xsl:value-of select="$from"/>
								</xsl:attribute>
								<xsl:attribute name="to">
									<xsl:value-of select="$id"/>
								</xsl:attribute>				
								<xsl:element name="type">
									<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLParam::paramType</xsl:attribute>
								</xsl:element>
							</xsl:element>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>

	<!-- edge class operation -->
		<xsl:element name="edge">     
			<xsl:attribute name="from">
				<xsl:value-of select="$classNamespace"/>
			</xsl:attribute>
			<xsl:attribute name="to">
				<xsl:value-of select="$operationNamespace"/>
			</xsl:attribute>
			<xsl:element name="type">
				<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLClass::methods</xsl:attribute>
			</xsl:element>
			<xsl:element name="attr">
				<xsl:attribute name="name">key</xsl:attribute>
				<xsl:element name="string">
					<xsl:value-of select="@name"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>

	</xsl:template>



	<xsl:template match="UML:TaggedValue">
				<!-- tagged value assoc
	
					<edge from="id141" to="id156">
			            <type xlink:href="de.uni_paderborn.fujaba.uml.UMLActivityDiagram::storyMethod"/>
			        </edge>
							        
			        <UML:TaggedValue tag="associates" value="&lt;{no name__getVar1}&gt;" xmi.id="TaggedValue.id141">
			            <UML:TaggedValue.modelElement>
			                <Foundation.Core.ModelElement xmi.idref="id156"/>
			            </UML:TaggedValue.modelElement>
			        </UML:TaggedValue>
	
				
				
				        <UML:Diagram diagramType="ActivityDiagram"
				            name="no name__getVar1" toolName="Fujaba" xmi.id="id141">
				            
				            <UML:Diagram.owner>
				                <Foundation.Core.ModelElement xmi.idref="ActivityGraph_id141"/>
				            </UML:Diagram.owner>
				            
				        </UML:Diagram>
				-->
				<!--
				   <UML:TaggedValue tag="clientRole" value="house" xmi.id="N400811">
            <UML:TaggedValue.modelElement>
                <Foundation.Core.ModelElement xmi.idref="id911578"/>
            </UML:TaggedValue.modelElement>
        </UML:TaggedValue>
        
        <UML:TaggedValue tag="clientCardinality" value="0..1" xmi.id="N400811">
            <UML:TaggedValue.modelElement>
                <Foundation.Core.ModelElement xmi.idref="id911578"/>
            </UML:TaggedValue.modelElement>
        </UML:TaggedValue>
				
				-->
				
	</xsl:template>



	<xsl:template match="UML:Diagram"><!--rootpackage , classdiagram-->

		<xsl:if test="@diagramType='ClassDiagram'">
			<xsl:variable name="diag">
				<xsl:value-of select="@xmi.id"/>
			</xsl:variable>
			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.uml.UMLClassDiagram</xsl:attribute>
					<xsl:attribute name="xlink:type">simple</xsl:attribute>
				</xsl:element>
				<xsl:element name="attr">
					<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLDiagram::name</xsl:attribute>
			                <string><xsl:value-of select="@name"/></string>
		                </xsl:element>
			</xsl:element>
			
			<!-- can't get generalization -->
			
			<xsl:for-each select="UML:Diagram.element/UML:DiagramElement">
				<xsl:element name="edge">
					<xsl:attribute name="to">
						<xsl:value-of select="UML:PresentationElement.subject/Foundation.Core.ModelElement/@xmi.idref"/>
					</xsl:attribute>
					<xsl:attribute name="from">
						<xsl:value-of select="$diag"/>
					</xsl:attribute>
					<xsl:element name="type">
						<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.asg.ASGDiagram::elements</xsl:attribute>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="@diagramType='ActivityDiagram'">
			<xsl:variable name="diag">
				<xsl:value-of select="@xmi.id"/>
			</xsl:variable>
			
			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLActivityDiagram</xsl:text>
					</xsl:attribute>
					<xsl:attribute name="xlink:type">
						<xsl:text>simple</xsl:text>
					</xsl:attribute>
				</xsl:element>
				<xsl:element name="attr">
					<xsl:attribute name="name">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLDiagram::name</xsl:text>
					</xsl:attribute>
					<xsl:element name="string">
	                	<xsl:value-of select="translate(@name,'_',':')"/>
	                </xsl:element>
				</xsl:element>
			</xsl:element>


			<xsl:for-each select="UML:Diagram.element/UML:DiagramElement">
				<xsl:element name="edge">     
					<xsl:attribute name="from">
						<xsl:value-of select="$diag"/>
					</xsl:attribute>
					<xsl:attribute name="to">
						<xsl:value-of select="UML:PresentationElement.subject/Foundation.Core.ModelElement/@xmi.idref"/>
					</xsl:attribute>
					<xsl:element name="type">
						<xsl:attribute name="xlink:href">de.uni_paderborn.fujaba.asg.ASGDiagram::elements</xsl:attribute>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
			

			<!-- content of activity diagram processed in template UML:ActivityGraph -->
			
			
		</xsl:if>
		
	</xsl:template>
	
	
	
	<xsl:template match="UML:ActivityGraph">
	<!-- create umlactivity content -->
	<xsl:for-each select="UML:StateMachine.top/UML:CompositeState/UML:CompositeState.subvertex">
		<xsl:for-each select="UML:Pseudostate">
			<xsl:choose>	
				<xsl:when test="@kind='initial'">
					<xsl:element name="node">
						<xsl:attribute name="id">
							<xsl:value-of select="@xmi.id"/>
						</xsl:attribute>
						<xsl:element name="type">
							<xsl:attribute name="xlink:href">
								<xsl:text>de.uni_paderborn.fujaba.uml.UMLStartActivity</xsl:text>
							</xsl:attribute>
							<xsl:attribute name="xlink:type">
								<xsl:text>simple</xsl:text>
							</xsl:attribute>
						</xsl:element>
						<xsl:element name="attr">
							<xsl:attribute name="name">
								<xsl:text>de.uni_paderborn.fujaba.uml.UMLStartActivity::storyName</xsl:text>
							</xsl:attribute>
							<xsl:element name="string">
		        	    	   	<xsl:value-of select="@name"/>
			       	        </xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:when>
				<xsl:when test="@kind='branch'">
					<xsl:element name="node">
						<xsl:attribute name="id">
							<xsl:value-of select="@xmi.id"/>
						</xsl:attribute>
						<xsl:element name="type">
							<xsl:attribute name="xlink:href">
								<xsl:text>de.uni_paderborn.fujaba.uml.UMLNopActivity</xsl:text>
							</xsl:attribute>
							<xsl:attribute name="xlink:type">
								<xsl:text>simple</xsl:text>
							</xsl:attribute>
						</xsl:element>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	
		<xsl:for-each select="UML:ActionState">
	
			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLStatementActivity</xsl:text>
					</xsl:attribute>
					<xsl:attribute name="xlink:type">
						<xsl:text>simple</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
	
			<xsl:element name="edge">           
				<xsl:attribute name="from">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:text>UMLStatement_</xsl:text><xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLStatementActivity::state</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>

			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:text>UMLStatement_</xsl:text><xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLStatement</xsl:text>
					</xsl:attribute>
					<xsl:attribute name="xlink:type">
						<xsl:text>simple</xsl:text>
					</xsl:attribute>
				</xsl:element>
	
				<xsl:element name="attr">
					<xsl:attribute name="name">de.uni_paderborn.fujaba.uml.UMLStatement::statement</xsl:attribute>
					<xsl:element name="string">
						<xsl:value-of select="@name"/>
					</xsl:element>
				</xsl:element>
			</xsl:element>
	        <!-- rückkante
	        <edge from="id190" to="id185">
	            <type xlink:href="de.uni_paderborn.fujaba.uml.UMLStatement::activity"/>
	        </edge>
			-->
		</xsl:for-each>

	
		<xsl:for-each select="UML:FinalState">

			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLStopActivity</xsl:text>
					</xsl:attribute>
					<xsl:attribute name="xlink:type">
						<xsl:text>simple</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<!--
			<UML:FinalState name="EndState.3" xmi.id="id187"/>
		     <node id="id187">
	            <type xlink:href="de.uni_paderborn.fujaba.uml.UMLStopActivity" xlink:type="simple"/>
	        </node>
	        -->
		</xsl:for-each>
	</xsl:for-each>
	

	<xsl:for-each select="UML:StateMachine.transitions/UML:Transition">
	
	
			<xsl:element name="node">
				<xsl:attribute name="id">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLTransition</xsl:text>
					</xsl:attribute>
					<xsl:attribute name="xlink:type">
						<xsl:text>simple</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
	
			<xsl:element name="edge">           
				<xsl:attribute name="from">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:value-of select="UML:Transition.target/Behavioral_Elements.State_Machines.StateVertex/@xmi.idref"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLTransition::revEntry</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>

			<xsl:element name="edge">           
				<xsl:attribute name="from">
					<xsl:value-of select="@xmi.id"/>
				</xsl:attribute>
				<xsl:attribute name="to">
					<xsl:value-of select="UML:Transition.source/Behavioral_Elements.State_Machines.StateVertex/@xmi.idref"/>
				</xsl:attribute>
				<xsl:element name="type">
					<xsl:attribute name="xlink:href">
						<xsl:text>de.uni_paderborn.fujaba.uml.UMLTransition::revExit</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<!-- rueckkanten -->	
		</xsl:for-each>
	</xsl:template>


</xsl:stylesheet>



